/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.FmtUI;
import com.quantumdata.fmteditor.editor.GateTrioSpec;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.fmteditor.fmtwidgets.FmtButtonUI;
import com.quantumdata.std.QDUtil;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class GateTrioPanel
extends QDPanel {
    private static final long serialVersionUID = 1L;
    private Format m_fmt;
    private GateTrioSpec m_spec;
    private ImageIcon[] m_icons = null;

    public GateTrioPanel(Format format, GateTrioSpec gateTrioSpec) {
        this.m_fmt = format;
        this.m_spec = gateTrioSpec;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        if (this.m_icons == null) {
            this.m_icons = new ImageIcon[8];
            this.m_icons[0] = QDUtil.loadIcon((String)"gateOff.png");
            this.m_icons[1] = QDUtil.loadIcon((String)"gateOn.png");
            this.m_icons[2] = QDUtil.loadIcon((String)"gateOffRoll.png");
            this.m_icons[3] = QDUtil.loadIcon((String)"gateOnRoll.png");
            this.m_icons[4] = QDUtil.loadIcon((String)"minus.png");
            this.m_icons[5] = QDUtil.loadIcon((String)"plus.png");
            this.m_icons[6] = QDUtil.loadIcon((String)"minusRoll.png");
            this.m_icons[7] = QDUtil.loadIcon((String)"plusRoll.png");
        }
        QDLabel qDLabel = new QDLabel(this.m_spec.title);
        qDLabel.setHorizontalAlignment(0);
        this.add((Component)qDLabel, "North");
        QDPanel qDPanel = new QDPanel();
        qDPanel.setLayout((LayoutManager)new GridBagLayout());
        for (int i = 0; i < 3; ++i) {
            this.addGate(i, i, qDPanel);
        }
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        this.add((Component)qDPanel, "Center");
    }

    private void addGate(int n, int n2, QDPanel qDPanel) {
        GridBagLayout gridBagLayout = (GridBagLayout)qDPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        QDLabel qDLabel = new QDLabel(this.m_spec.gateLabel[n2]);
        qDLabel.setForeground(QDStdUI.getActionForeground());
        int n3 = this.m_spec.iconType == 2 ? 0 : 4;
        JToggleButton jToggleButton = new JToggleButton(this.m_icons[n3]);
        jToggleButton.setSelectedIcon(this.m_icons[n3 + 1]);
        jToggleButton.setRolloverIcon(this.m_icons[n3 + 2]);
        jToggleButton.setRolloverSelectedIcon(this.m_icons[n3 + 3]);
        jToggleButton.setFocusable(true);
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setSize(new Dimension(this.m_icons[n3].getIconWidth(), this.m_icons[n3].getIconHeight()));
        jToggleButton.setEnabled(true);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints((Component)qDLabel, gridBagConstraints);
        qDPanel.add((Component)qDLabel);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jToggleButton, gridBagConstraints);
        qDPanel.add((Component)jToggleButton);
        CmdValue cmdValue = this.m_fmt.getValue(this.m_spec.gateFmtId[n2]);
        jToggleButton.setSelected(cmdValue.getBool());
        jToggleButton.addActionListener(new GateAction(cmdValue));
        jToggleButton.setToolTipText("Toggle " + cmdValue.getName());
        jToggleButton.setBorderPainted(false);
        jToggleButton.setUI(FmtButtonUI.create());
    }

    private class GateAction
    implements ActionListener {
        private CmdValue m_value;

        public GateAction(CmdValue cmdValue) {
            this.m_value = cmdValue;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_value.setBool(((JToggleButton)actionEvent.getSource()).isSelected());
        }
    }
}

